/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest.cloning;

import com.ibm.hwmca.base.saverest.cloning.CloningConstants;
import com.ibm.hwmca.base.saverest.cloning.CloningErrorIds;
import com.ibm.hwmca.base.saverest.cloning.CloningUtil;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class CloningService
implements FcsService,
CloningConstants,
CloningErrorIds {
    private static final String TRACE_MASKT = "XSRDCSVT";
    private static final String TRACE_MASKF = "XSRDCSVF";
    private static final String TRACE_MASKD = "XSRDCSVD";
    private CloningUtil cloningUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConnection(FcsConnection connection) {
        block13: {
            Trace.trace(TRACE_MASKD, "Processing new connection");
            try {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
                Map map = (Map)ois.readObject();
                this.cloningUtil = new CloningUtil();
                Object command = map.get("cloningAction");
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(connection.getSocket().getOutputStream()));
                oos.flush();
                if ("SaveButton".equals(command)) {
                    Map dataMap = (Map)map.get("dataMap");
                    CompletionReport report = this.cloningUtil.receiveClonedData(dataMap);
                    oos.writeObject(report);
                    oos.flush();
                    break block13;
                }
                if ("RestoreButton".equals(command)) {
                    String[] stringArray = (String[])map.get("uiInfoArray");
                    Map dataMap = this.cloningUtil.buildRequestedData(stringArray);
                    oos.writeObject(dataMap);
                    oos.flush();
                    break block13;
                }
                throw new Exception("Unknown cloning state");
            }
            catch (Exception e) {
                this.log(e);
            }
            finally {
                try {
                    connection.getSocket().close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void log(Exception e) {
        Trace.trace(TRACE_MASKF, "Exception in cloning service:" + e.getMessage());
        new FrameworkLog(CloningErrorIds._logInfo, 261, e).log(FrameworkLogAttributes.INFO_LOG);
    }
}

